package com.ejie.ab04b.dao.custom;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteOS2Dao;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteOS2Dao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TramiteOS2CustomDao extends TramiteOS2Dao {

	/**
	 * Finds a single row in the TramiteOS2 table.
	 * 
	 *  tramiteOS2
	 *            TramiteOS2
	 *  TramiteOS2
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @return the tramite OS 2
	 */
	@Transactional(readOnly = true)
	public TramiteOS2 vfind(TramiteOS2 tramiteOS2);

	/**
	 * Finds a single row in the TramiteOS2 table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os2
	 *            OS2
	 *  TramiteOS2
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os2 the os 2
	 * @return the tramite OS 2
	 */
	@Transactional(readOnly = true)
	public TramiteOS2 findLastTramiteByTipo(Long idTipoTramite, OS2 os2);

	/**
	 * Finds a list of rows in the TramiteOS2 table.
	 * 
	 *  tramiteOS2
	 *            TramiteOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteOS2>
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS2> vfindAll(TramiteOS2 tramiteOS2,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TramiteOS2 table.
	 * 
	 *  filterAb0492s00
	 *            TramiteOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  b
	 *            boolean
	 *  List<TramiteOS2>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param b the b
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS2> findAllImprimirDocsOS2Like(
			TramiteOS2 filterAb0492s00, JQGridRequestDto jqGridRequestDto,
			boolean b);

	/**
	 * Number of rows.
	 * 
	 *  tramiteOS2
	 *            TramiteOS2
	 *  b
	 *            boolean
	 *  Long
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @param b the b
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeImprimirDocsOS2Count(TramiteOS2 tramiteOS2, boolean b);

}
